% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_get_params}
\alias{pipe_get_params}
\alias{pipe_get_params_at_step}
\alias{pipe_get_params_unique}
\alias{pipe_get_params_unique_json}
\title{Get pipeline parameters}
\usage{
pipe_get_params(pip, ignoreHidden = TRUE)

pipe_get_params_at_step(pip, step, ignoreHidden = TRUE)

pipe_get_params_unique(pip, ignoreHidden = TRUE)

pipe_get_params_unique_json(pip, ignoreHidden = TRUE)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{ignoreHidden}{\code{logical} if TRUE, hidden parameters (i.e. all
paramater names starting with a dot) are ignored and thus not returned.}

\item{step}{\code{string} name of step}
}
\value{
\itemize{
\item \code{pipe_get_params}: list of parameters, sorted and named by step -
steps with no parameters are filtered out
\item \code{pipe_get_params_at_step}: list of parameters at given step
\item \code{pipe_get_params_unique}:  list of parameters where each parameter
is only listed once. The values of the parameters will be the values
of the first step where the parameters were defined, respectively.
\item \code{get_params_unique_json}: flat unnamed json list of unique parameters
}
}
\description{
Retrieves unbound function parameters defined in
the pipeline where 'unbound' means parameters that are not linked
to other steps.
}
\examples{
# pipe_get_params
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "add1", \(data = ~data, x = 1) x + data)
pipe_add(p, "add2", \(x = 1, y = 2, .z = 3) x + y + .z)
pipe_add(p, "add3", \() 1 + 2)
pipe_get_params(p, ) |> str()
pipe_get_params(p, ignoreHidden = FALSE) |> str()

# pipe_get_params_at_step
pipe_get_params_at_step(p, "add2")
pipe_get_params_at_step(p, "add2", ignoreHidden = FALSE)
pipe_get_params_at_step(p, "add3")

# pipe_get_params_unique
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "add1", \(data = ~data, x = 1) x + data)
pipe_add(p, "add2", \(x = 1, y = 2, .z = 3) x + y + .z)
pipe_add(p, "mult1", \(x = 4, y = 5, .z = 6, b = ~add2) x * y * b)
pipe_get_params_unique(p)
pipe_get_params_unique(p, ignoreHidden = FALSE)

# get_params_unique_json
pipe_get_params_unique_json(p)
pipe_get_params_unique_json(p, ignoreHidden = FALSE)
}
