% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_append}
\alias{pipe_append}
\title{Append two pipelines}
\usage{
pipe_append(pip, p, outAsIn = FALSE, tryAutofixNames = TRUE, sep = ".")
}
\arguments{
\item{pip}{\code{Pipeline} object to be appended to.}

\item{p}{\code{Pipeline} object to be appended.}

\item{outAsIn}{\code{logical} if \code{TRUE}, output of first pipeline is used
as input for the second pipeline.}

\item{tryAutofixNames}{\code{logical} if \code{TRUE}, name clashes are tried
to be automatically resolved by appending the 2nd pipeline's name.
Only set to \code{FALSE}, if you know what you are doing.}

\item{sep}{\code{string} separator used when auto-resolving step names}
}
\value{
returns new combined \code{Pipeline} object.
}
\description{
When appending, \code{pipeflow} takes care of potential name
clashes with respect to step names and dependencies, that is, if
needed, it will automatically adapt step names and dependencies to
make sure they are unique in the merged pipeline.
}
\examples{
# Append pipeline
p1 <- pipe_new("pipe1")
pipe_add(p1, "step1", \(x = 1) x)
p2 <- pipe_new("pipe2")
pipe_add(p2, "step2", \(y = 1) y)
p1 |> pipe_append(p2)

# Append pipeline with potential name clashes
p3 <- pipe_new("pipe3")
pipe_add(p3, "step1", \(z = 1) z)
p1 |> pipe_append(p2) |> pipe_append(p3)

# Use output of first pipeline as input for second pipeline
p1 <- pipe_new("pipe1", data = 8)
p2 <- pipe_new("pipe2")
pipe_add(p1, "square", \(x = ~data) x^2)
pipe_add(p2, "log2", \(x = ~data) log2(x))

p12 <- p1 |> pipe_append(p2, outAsIn = TRUE)
p12 |> pipe_run() |> pipe_get_out("log2")
p12

# Custom name separator for adapted step names
p1 |> pipe_append(p2, sep = "___")
}
