% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.genes.R
\name{rename.genes}
\alias{rename.genes}
\title{Name or rename a list of gene trees or matrices}
\usage{
rename.genes(X, gene.names = NULL)
}
\arguments{
\item{X}{A list of trees or matrices}

\item{gene.names}{List of names to assign to the elements of X. Must be of the same length as length(X). 
If NULL (the default) the object are numbered 1,2,...,length(X).}
}
\value{
X with name assigned to each element.
}
\description{
Name or rename a list of gene trees or gene matrices genes. For internal use mostly.
}
\examples{

data(carnivora)

# names before renaming
names(carnivora)

carnivora.renamed<-rename.genes(carnivora, gene.names=as.character(1:length(carnivora)))

# names after renaming
names(carnivora.renamed)
}
