% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Median normalization of 2D matrix by row or by colomn}
\usage{
normalize(mat, what = "none")
}
\arguments{
\item{mat}{A matrix}

\item{what}{Character string indicating whether the matrix should be
normalized and how. If what="none", the matrix is not normalized (the
default), if what="species", the matrix is normalized so that the difference
between species is increased, and if what="genes", the matrix is normalized
so that the difference between genes is increased. Normalization consists
in dividing either each row or each columns by its median.}
}
\value{
A normalized matrix
}
\description{
This function normalizes the 2WR matrix (or any 2D matrix) according to the
species (rows) or to the genes (columns), by dividing each row or each column by its median.
}
\examples{
# random matrix
x<-matrix(rnorm(270), nrow=9, ncol=14)

# normalize by row
x1<-normalize(x, "genes")

# normalize by column
x2<-normalize(x, "species")



}
