% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pie.R
\name{plot_pie}
\alias{plot_pie}
\title{Visualize biogeographic patterns using pie charts}
\usage{
plot_pie(
  omega,
  pol,
  radius = 0.55,
  col = hcl.colors(5),
  pie_control = list(),
  legend = FALSE,
  legend_pie = FALSE,
  ...
)
}
\arguments{
\item{omega}{a matrix of phyloregion of probabilities of each species}

\item{pol}{a vector polygon of grid cells with a column labeled
\dQuote{grids}.}

\item{radius}{Radius of the pie legend to be displayed}

\item{col}{List of colors for the pies.}

\item{pie_control}{The list of control parameters to be passed into
the add.pie function.}

\item{legend}{Logical, whether to plot a legend or not.}

\item{legend_pie}{Legend for the pie plots.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns no value, just map color pies in geographic space!
}
\description{
Visualize biogeographic patterns using pie charts
}
\examples{
library(terra)
data(africa)
p <- vect(system.file("ex/sa.json", package = "phyloregion"))
K <- ncol(africa$omega)

CLRS <- hcl.colors(K)
plot_pie(africa$omega, pol = p, col=CLRS)
}
