% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample2sparsematrix.R
\name{long2sparse}
\alias{long2sparse}
\alias{sparse2long}
\alias{dense2sparse}
\alias{sparse2dense}
\alias{long2dense}
\alias{dense2long}
\title{Conversion of community data}
\usage{
long2sparse(x, grids = "grids", species = "species")

sparse2long(x)

dense2sparse(x)

sparse2dense(x)

long2dense(x)

dense2long(x)
}
\arguments{
\item{x}{A community data which one wants to transform}

\item{grids}{column name of the column containing grid cells}

\item{species}{column name of the column containing  the species / taxa names}
}
\value{
A compressed sparse community matrix of sites by species
}
\description{
These functions convert a community data to compressed sparse matrix,
dense matrix and long format (e.g. species records).
}
\examples{
data(africa)
africa$comm[1:5, 1:20]
long <- sparse2long(africa$comm)
long[1:5, ]
sparse <- long2sparse(long)
all.equal(africa$comm, sparse)

dense_comm <- matrix(c(1,0,1,1,0,0,
                1,0,0,1,1,0,
                1,1,1,1,1,1,
                0,0,1,1,0,1), 6, 4,
              dimnames=list(paste0("g",1:6), paste0("sp", 1:4)))
dense_comm
sparse_comm <- dense2sparse(dense_comm)
sparse_comm
sparse2long(sparse_comm)

}
\keyword{Conversion}
