% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-tuv-file.r
\name{read_qtuv_txt}
\alias{read_qtuv_txt}
\title{Read Quick TUV output file.}
\usage{
read_qtuv_txt(
  file,
  ozone.du = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale(),
  added.vars = NULL
)
}
\arguments{
\item{file}{character string with the name of a text file.}

\item{ozone.du}{numeric Ozone column in Dobson units.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone is by default read from the file.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{added.vars}{character vector Accepted member values are \code{"sun.elevation"},
\code{zenith.angle}, \code{"time"} and \code{"ozone.du"}.}
}
\value{
a source_spct object obtained by finding the center of wavelength
  intervals in the Quick TUV output file, and adding the variables listed
  in \code{added.vars}. To obtain the same value as in version (<= 0.4.28)
  pass \code{added.vars = c("angle", "date")} in the call.
}
\description{
Reads and parses the header of a text file output by the Quick TUV on-line
web front-end at UCAR to extract the header and spectral data. The time field
is converted to a date.
}
\note{
The ozone column value used in the simulation cannot be retrieved from
the file. Tested files from Quick TUV version 5.2 on 2018-07-30 and also
with more recent files in early 2024. This 
function can be expected to be robust to variations in the position of lines
in the imported file and resistant to the presence of extraneous text or
even summaries. By default web browsers save the output returned by the
Quick TUV calculator as an HTML output, some of them with minimal headers
and other with more extensive ones. In some cases, character escapes replace
actual new lines. In most cases these HTML files are decoded correctly, but
if not, use "save as" in the browser and select "text" when saving. As a
last recourse, messed up files can be manually edited before import.
}
\references{
\url{https://www.acom.ucar.edu/Models/TUV/Interactive_TUV/}
}
