% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.r
\name{is_effective}
\alias{is_effective}
\alias{is_effective.default}
\alias{is_effective.waveband}
\alias{is_effective.generic_spct}
\alias{is_effective.source_spct}
\alias{is_effective.summary_generic_spct}
\alias{is_effective.summary_source_spct}
\title{Is an R object "effective"}
\usage{
is_effective(x)

\method{is_effective}{default}(x)

\method{is_effective}{waveband}(x)

\method{is_effective}{generic_spct}(x)

\method{is_effective}{source_spct}(x)

\method{is_effective}{summary_generic_spct}(x)

\method{is_effective}{summary_source_spct}(x)
}
\arguments{
\item{x}{an R object}
}
\value{
A \code{logical}.
}
\description{
A generic function for querying if a biological spectral weighting function
(BSWF) has been applied to an object or is included in its definition.
}
\section{Methods (by class)}{
\itemize{
\item \code{is_effective(default)}: Default method.

\item \code{is_effective(waveband)}: Is a \code{waveband} object defining a method for
calculating effective irradiance.

\item \code{is_effective(generic_spct)}: Does a \code{source_spct} object contain effective
spectral irradiance values.

\item \code{is_effective(source_spct)}: Does a \code{source_spct} object contain effective
spectral irradiance values.

\item \code{is_effective(summary_generic_spct)}: Method for "summary_generic_spct".

\item \code{is_effective(summary_source_spct)}: Method for "summary_source_spct".

}}
\examples{
is_effective(summary(sun.spct))

}
\seealso{
Other waveband attributes: 
\code{\link{labels}()},
\code{\link{normalization}()}
}
\concept{waveband attributes}
