% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeEncryptedData.R
\name{write.aes}
\alias{write.aes}
\title{Write Encrypted Data.}
\usage{
write.aes(df, filename, key)
}
\arguments{
\item{df}{Data to encrypt.}

\item{filename}{Location where to save encrypted data.}

\item{key}{Encryption key.}
}
\value{
A file with encrypted data.
}
\description{
Write data to encrypted file.
}
\details{
Writes data to an encrypted file. To read data from an encrypted file, see
\link{read.aes}.
}
\examples{
\donttest{
# Location Where to Save Encryption Key on Local Computer
  #(where only you should have access to it)
#encryptionKeyLocation <- file.path(getwd(), "/encryptionKey.RData",
#  fsep = "") #Can change to a different path, e.g.: "C:/Users/[USERNAME]/"

# Generate a Temporary File Path for Encryption Key
encryptionKeyLocation <- tempfile(fileext = ".RData")

# Generate Encryption Key
key <- as.raw(sample(1:16, 16))

# Save Encryption Key
save(key, file = encryptionKeyLocation)

# Specify Credentials
credentials <- "Insert My Credentials Here"

# Generate a Temporary File Path for Encrypted Credentials
encryptedCredentialsLocation <- tempfile(fileext = ".txt")

# Save Encrypted Credentials
#write.aes(
#  df = credentials,
#  filename = file.path(getwd(), "/encrypytedCredentials.txt", fsep = ""),
#  key = key) #Change the file location to save this on the lab drive

write.aes(
  df = credentials,
  filename = encryptedCredentialsLocation,
  key = key)

rm(credentials)
rm(key)
}

}
\seealso{
\url{https://stackoverflow.com/questions/25318800/how-do-i-read-an-encrypted-file-from-disk-with-r/25321586#25321586}

Other encrypted: 
\code{\link{read.aes}()}
}
\concept{encrypted}
