% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanSum.R
\name{meanSum}
\alias{meanSum}
\title{Mean Sum.}
\usage{
meanSum(x)
}
\arguments{
\item{x}{Matrix or dataframe with participants in the rows and items in the
columns.}
}
\value{
Missingness-adjusted row sum.
}
\description{
Compute a missingness-adjusted row sum.
}
\details{
Take row mean across columns (items) and then multiply by number of items to
account for missing (\code{NA}) values.
}
\examples{
# Prepare Data
df <- data.frame(item1 = rnorm(1000), item2 = rnorm(1000), item3 = rnorm(1000))

# Calculate Missingness-Adjusted Row Sum
df$missingnessAdjustedSum <- meanSum(df)
}
\seealso{
Other computations: 
\code{\link{Mode}()},
\code{\link{kish_ess}()},
\code{\link{mySum}()}
}
\concept{computations}
