% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owl.R
\name{owl}
\alias{owl}
\title{One-Way Layout Permutation Test}
\usage{
owl(df, rand = 9999, alpha.post = 0.05, type.post = "control", seed = 1)
}
\arguments{
\item{df}{a data frame with the name of experimental groups as the first
column and the measurement of responses as the remaining columns.}

\item{rand}{an integer, the number of randomization samples. The default value
is 9999.}

\item{alpha.post}{a numeric, the Type I error rate for multiple comparisons.
The default value is 0.05.}

\item{type.post}{the way of multiple comparisons, "all" for pairwise
comparisons or "control" for only comparisons with the control group.}

\item{seed}{an integer, the seed for random number generation. Setting a seed
ensures the reproducibility of the result. See \code{\link{set.seed}} for
more details.}
}
\value{
\code{owl} returns a list with 9 components:
 \item{\code{n.obs}}{the sample sizes.} \item{\code{avg.obs}}{the mean
 responses.} \item{\code{T.obs}}{the T statistic for global test.}
 \item{\code{pval}}{the p-value for global test.}
 \item{\code{pval.round}}{the reported form of p-value.}
 \item{\code{main.test}}{the strength of evidence against the null
 hypothesis.} \item{\code{d.multi.obs}}{the differences in means for multiple
 comparisons.} \item{\code{mad.cric}}{the critical value of maximum absolute
 differences in means.} \item{\code{post.test}}{\code{TRUE} if the
 differences are significant.}
}
\description{
\code{owl} performs the global test and multiple comparisons for single factor
experiments.
}
\details{
The first name appearing in the first column will determine the
 control group. The other names will be treatment groups.
}
\examples{
ernst2004 <- data.frame(
group = factor(rep(c("style1", "style2", "style3"), each = 5 ),
levels = c("style1", "style2", "style3")),
speed = c( 135,91,111,87, 122, 175,130,514,283, NA,105,147,159,107,194))
owl(ernst2004, type.post = "all")

}
\references{
Ernst, M. D. (2004). Permutation Methods: A Basis for Exact
 Inference. Statistical Science, 19(4), 676–685.
 \doi{10.1214/088342304000000396}. \cr \cr Muff, S., Nilsen, E. B., O’Hara,
 R. B., & Nater, C. R. (2022). Rewriting results sections in the language of
 evidence. Trends in Ecology & Evolution, 37(3), 203–210.
 \doi{10.1016/j.tree.2021.10.009}.
}
