% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_stock1_.R
\name{md_stock}
\alias{md_stock}
\title{query stock market data}
\usage{
md_stock(symbol, type = "history", date_range = "3y", from = NULL,
  to = Sys.Date(), forward = NULL, print_step = 1L, ...)
}
\arguments{
\item{symbol}{symbols of stock shares.}

\item{type}{the data type, including history, real. Defaults to history.}

\item{date_range}{date range. Available value including '1m'-'11m', 'ytd', 'max' and '1y'-. Default is '3y'.}

\item{from}{the start date. Default is NULL.}

\item{to}{the end date. Default is current system date.}

\item{forward}{whether to forward adjust the OHLC prices. If it is NULL, return the original data from source, defaults to NULL.}

\item{print_step}{A non-negative integer. Print symbol name by each print_step iteration. Default is 1L.}

\item{...}{Additional parameters.}
}
\description{
\code{md_stock} provides an interface to query stock or fund data.
}
\examples{
\dontrun{
# Example I: query history data
# us
FAANG = md_stock(c('META', 'AMZN', 'AAPL', 'NFLX', 'GOOG'))

# hkex
TMX = md_stock(c('00700.hk', '03690.hk', '01810.hk'))

# sse/szse
## the symbol without suffix
dt_cn1 = md_stock(c("000001", "^000001", "512510"))
## the symbol with suffix
dt_cn2 = md_stock(c("000001.sz", "000001.ss", '512510.ss'))

             
# Example III: query real prices
# real price for equities
dt_real1 = md_stock(c('META', 'AMZN', 'AAPL', 'NFLX', 'GOOG',
                     '00700.hk', '03690.hk', '01810.hk',
                     "000001", "^000001", "512510"), type = 'real')
               
               
# query company information 
dt_info1 = md_stock('600036', type = 'info')
}

}
