% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gw_cow_years}
\alias{gw_cow_years}
\title{Gleditsch-Ward states and Correlates of War, by year}
\format{
A data frame with 18425 observations on the following 6 variables.
\describe{
\item{\code{gwcode}}{a Gleditsch-Ward state code}
\item{\code{stateabb}}{the state abbreviation, which was the greatest source of agreement between both data sets}
\item{\code{gw_statename}}{the state name as it appears in the Gleditsch-Ward data}
\item{\code{ccode}}{a Correlates of War state code}
\item{\code{cow_statename}}{the state name as it appears in the Correlates of War data}
\item{\code{year}}{a numeric vector for the year}
}
}
\usage{
gw_cow_years
}
\description{
This is a complete (I believe) data set on Gleditsch-Ward states and Correlates of War states, a byproduct
of a \code{full_join()} between \code{gw_states} and \code{cow_states} that leans largely on the
state abbreviation variable.
}
\details{
The \code{data-raw} directory on the project's Github contains more information about how these data were
created. I'm going to use it for internal stuff. The workflow is going to treat the Gleditsch-Ward state system
membership codes as more of the "master" codes, for which the user can add Correlates of War identifiers as they see
fit. Data are extended to 2020, assuming no changes to state system membership for either data set.
}
\keyword{datasets}
