% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_minimum_distance.R
\name{add_minimum_distance}
\alias{add_minimum_distance}
\title{Add minimum distance data to your data frame}
\usage{
add_minimum_distance(data)
}
\arguments{
\item{data}{a data frame with appropriate \pkg{peacesciencer} attributes}
}
\value{
\code{add_minimum_distance()} takes a (dyad-year, leader-year, leader-dyad-year, state-year) data frame and adds the
minimum distance between the first state and the second state (in dyad-year data) or the minimum
minimum (sic) distance for a given state in a given year.
}
\description{
\code{add_minimum_distance()} allows you to add the minimum
distance (in kilometers) to a (dyad-year, leader-year, leader-dyad-year, state-year) data frame. These estimates
are recorded in the \code{cow_mindist} and \code{gw_mindist} data that come with this package. The
data are current as of the end of 2019.
}
\details{
The function leans on attributes of the data that are provided by one of the "create" functions
in this package (e.g. \code{create_dyadyear()} or \code{create_stateyear()}).
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)
cow_ddy \%>\% add_minimum_distance()

create_dyadyears(system = "gw") \%>\% add_minimum_distance()

create_stateyears(system ="gw") \%>\% add_minimum_distance()
}


}
\references{
Schvitz, Guy, Luc Girardin, Seraina Ruegger, Nils B. Weidmann, Lars-Erik Cederman,
and Kristian Skrede Gleditsch. 2022. "Mapping The International System, 1886-2017:
The \code{CShapes} 2.0 Dataset." \emph{Journal of Conflict Resolution}. 66(1): 144-161.

Weidmann, Nils B. and Kristian Skrede Gleditsch. 2010. "Mapping and Measuring Country Shapes: The \code{cshapes} Package."
\emph{The R Journal} 2(1): 18-24.
}
\author{
Steven V. Miller
}
