% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{print.pc_effect}
\alias{print.pc_effect}
\title{Print Pattern Causality Effect}
\usage{
\method{print}{pc_effect}(x, ...)
}
\arguments{
\item{x}{A \code{pc_effect} object.}

\item{...}{Additional arguments passed to the \code{print} function.}
}
\value{
Invisibly returns the input object.
}
\description{
Prints the pattern causality effect analysis results.
This function displays the received and exerted influences for each item
for positive, negative, and dark causality types.
}
\examples{
\donttest{
data(climate_indices)
dataset <- climate_indices[, -1]
pc_matrix_obj <- pcMatrix(dataset, E = 3, tau = 1, 
  metric = "euclidean", h = 1, weighted = TRUE, 
  verbose = FALSE)
effects <- pcEffect(pc_matrix_obj)
print(effects)
}
}
