% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModelTCCs.R
\name{plotModelTCCs}
\alias{plotModelTCCs}
\title{Plots Tucker Congruence Coefficients of randomly initialized models.}
\usage{
plotModelTCCs(models)
}
\arguments{
\item{models}{Models list output of \code{\link[=parafac]{parafac()}} using output="all".}
}
\value{
Plot of TCCs
}
\description{
Plots Tucker Congruence Coefficients of randomly initialized models.
}
\examples{
processedFujita = processDataCube(Fujita2023, sparsityThreshold=0.99, centerMode=1, scaleMode=2)
models = parafac(processedFujita$data, 3, nstart=10, output="all")
plotModelTCCs(models)
}
