% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_text.R
\name{sanitize_terms}
\alias{sanitize_terms}
\alias{sanitize_terms.character}
\alias{sanitize_terms.factor}
\alias{sanitize_terms.data.frame}
\alias{sanitize_terms.list}
\title{Sanitize Term Names}
\usage{
sanitize_terms(x, standardized = FALSE)

\method{sanitize_terms}{character}(x, standardized = FALSE)

\method{sanitize_terms}{factor}(x, standardized = FALSE)

\method{sanitize_terms}{data.frame}(x, standardized = FALSE)

\method{sanitize_terms}{list}(x, standardized = FALSE)
}
\arguments{
\item{x}{Character. Vector of term names to be sanitized.}

\item{standardized}{Logical. If \code{TRUE}, the name of the function [\code{\link[=scale]{scale()}}] will be
removed from term names.}
}
\value{
An object of the same class as \code{x} containing sanitized term names as
characters.
}
\description{
Remove characters from term names that will be difficult to address using the \code{$}-operator.
\emph{This function is not exported.}
}
\examples{
  sanitize_terms(c("(Intercept)", "Factor A", "Factor B", "Factor A:Factor B", "scale(FactorA)"))
}
