% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_text.R
\name{beautify_terms}
\alias{beautify_terms}
\alias{beautify_terms.character}
\alias{beautify_terms.numeric}
\alias{beautify_terms.factor}
\alias{beautify_terms.data.frame}
\title{Prettify Term Names}
\usage{
beautify_terms(x, ...)

\method{beautify_terms}{character}(x, standardized = FALSE, retain_period = FALSE, ...)

\method{beautify_terms}{numeric}(x, standardized = FALSE, ...)

\method{beautify_terms}{factor}(x, standardized = FALSE, ...)

\method{beautify_terms}{data.frame}(x, ...)
}
\arguments{
\item{x}{Character. Vector of term names to be prettified.}

\item{...}{Additional arguments passed to \code{\link[=apa_num]{apa_num()}}, for numeric values in
\code{x}, ignored otherwise.}

\item{standardized}{Logical. If \code{TRUE}, the name of the function \code{\link[=scale]{scale()}} will be
removed from term names.}

\item{retain_period}{Logical. If \code{TRUE}, any periods in term names will be
retained, otherwise they will be replaced by a space.}
}
\value{
A character vector or \code{data.frame} (if \code{x} is a \code{data.frame})
containing term names modified for nicer printing.
}
\description{
Remove parentheses, replace colons with \code{$\\times$}.
Useful to prettify term names in \code{\link[=apa_print]{apa_print()}} tables.
}
\examples{
beautify_terms("a:b")
beautify_terms("scale(x)", standardized = TRUE)
beautify_terms("snake_case")
}
