% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_num.R
\name{apa_df}
\alias{apa_df}
\alias{print_df}
\title{Typeset Degrees of Freedom}
\usage{
apa_df(x, digits = 2L, big.mark = "", elementwise = TRUE)

print_df(x, digits = 2L, big.mark = "", elementwise = TRUE)
}
\arguments{
\item{x}{Numeric. The degrees of freedom to report.}

\item{digits}{Integer. The desired number of digits after the decimal point to
be used if \code{x} contains non-integer values.}

\item{big.mark}{character; if not empty used as mark between every
    \code{big.interval} decimals \emph{before} (hence \code{big}) the
    decimal point.}

\item{elementwise}{Logical. Determines whether the number of trailing digits
should be determined for each element of \code{x} separately (the default),
or for the complete vector \code{x}.}
}
\value{
An object of the same class as \code{x} with all numeric values converted
to character.
}
\description{
This is a function for processing degrees of freedom. It takes care
that trailing digits are only printed if non-integer values are given.
}
\examples{
apa_df(c(1, 1.23151))
}
\seealso{
\code{\link[=apa_num]{apa_num()}}, \code{\link[=apa_p]{apa_p()}}
}
