% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_specimen}
\alias{pbdb_specimen}
\title{Get information about a single fossil specimen}
\usage{
pbdb_specimen(id, ...)
}
\arguments{
\item{id}{The identifier of the specimen.  This parameter is
required.}

\item{...}{Arguments passed to the API.  See all available
arguments at \url{https://paleobiodb.org/data1.2/specs/single}.
\itemize{
\item \code{vocab}: Set to "pbdb" to show the complete name of the variables
(by default variables have short 3-letter names).
\item \code{show}: Select additional blocks of information to be returned
along with the basic record.  Some possible values include:
\itemize{
\item \code{"loc"}: Additional information about the geographic locality
of the associated occurrence, if any.
\item \code{"stratext"}: Detailed information about the stratigraphic
context of the associated occurrence.
\item \code{"lithext"}: Detailed information about the lithological
context of the associated occurrence.
\item \code{"refattr"}: The author(s) and year of publication of the
reference from which this data was entered. If no reference
is recorded for this specimen, the information from the
associated occurrence or collection reference is returned
instead.
}
}}
}
\value{
A data frame with information about a single specimen.
}
\description{
Returns information about a single fossil specimen, identified
either by name or by identifier.
}
\examples{
\dontrun{
pbdb_specimen(id = 30050, show = c("class", "loc", "refattr"))
}
}
