% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_measurements}
\alias{pbdb_measurements}
\title{Get information about specimen measurements}
\usage{
pbdb_measurements(...)
}
\arguments{
\item{...}{Arguments passed to the API.  See all available
arguments at \url{https://paleobiodb.org/data1.2/specs/measurements}.

The following parameters can be used to retrieve measurements from
a known list of specimens, occurrences, or collections. Only the
records matching all specified parameters will be returned:
\itemize{
\item \code{spec_id}: A list of specimen identifiers.
\item \code{occ_id}: A list of occurrence identifiers.
\item \code{coll_id}: A list of collection identifiers.
}

It is possible to return additional information along with the
basic record with the following parameter:
\itemize{
\item \code{show}: Possible values include:
\itemize{
\item \code{"spec"}: Includes all of the core fields describing the
specimen from which this measurement was taken.
\item \code{"methods"}: Information about the collection methods used.
}
}

See the \code{\link[=pbdb_occurrences]{pbdb_occurrences()}} documentation for an explanation about
more filtering parameters.}
}
\value{
A data frame with information about the measurements that
match the query.
}
\description{
Returns information about the measurements associated with the
selected fossil specimens.
}
\examples{
\dontrun{
  pbdb_measurements(
    spec_id = c(1505, 30050),
    show = c("spec", "class", "methods"),
    vocab = "pbdb"
  )
}
}
