% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p1app4p2.R
\name{tp2c.view.pathways}
\alias{tp2c.view.pathways}
\title{View pathway or gene-weighted PCA
'Pagoda2' version of the function pagoda.show.pathways()
Takes in a list of pathways (or a list of genes), runs weighted PCA, optionally showing the result.}
\usage{
tp2c.view.pathways(
  pathways,
  p2,
  goenv = NULL,
  batch = NULL,
  n.genes = 20,
  two.sided = TRUE,
  n.pc = rep(1, length(pathways)),
  colcols = NULL,
  zlim = NULL,
  labRow = NA,
  vhc = NULL,
  cexCol = 1,
  cexRow = 1,
  nstarts = 50,
  row.order = NULL,
  show.Colv = TRUE,
  plot = TRUE,
  trim = 1.1/nrow(p2$counts),
  showPC = TRUE,
  ...
)
}
\arguments{
\item{pathways}{character vector of pathway or gene names}

\item{p2}{'Pagoda2' object}

\item{goenv}{environment mapping pathways to genes (default=NULL)}

\item{batch}{factor (corresponding to rows of the model matrix) specifying batch assignment of each cell, to perform batch correction (default=NULL).}

\item{n.genes}{integer Number of genes to show (default=20)}

\item{two.sided}{boolean If TRUE, the set of shown genes should be split among highest and lowest loading (default=TRUE). If FALSE, genes with highest absolute loading should be shown.}

\item{n.pc}{integer vector Number of principal component to show for each listed pathway(default=rep(1, length(pathways)))}

\item{colcols}{column color matrix (default=NULL)}

\item{zlim}{numeric z color limit (default=NULL)}

\item{labRow}{row labels (default=NA)}

\item{vhc}{cell clustering (default=NULL)}

\item{cexCol}{positive numbers, used as cex.axis in for the row or column axis labeling(default=1)}

\item{cexRow}{positive numbers, used as cex.axis in for the row or column axis labeling(default=1)}

\item{nstarts}{integer Number of random starts to use (default=50)}

\item{row.order}{row order (default=NULL). If NULL, uses order from hclust.}

\item{show.Colv}{boolean Whether to show cell dendrogram (default=TRUE)}

\item{plot}{boolean Whether to plot (default=TRUE)}

\item{trim}{numeric Winsorization trim that should be applied (default=1.1/nrow(p2$counts)). Note that p2 is a 'Pagoda2' object.}

\item{showPC}{boolean (default=TRUE)}

\item{...}{parameters to pass to my.heatmap2. Only if plot is TRUE.}
}
\value{
cell scores along the first principal component of shown genes (returned as invisible)
}
\description{
View pathway or gene-weighted PCA
'Pagoda2' version of the function pagoda.show.pathways()
Takes in a list of pathways (or a list of genes), runs weighted PCA, optionally showing the result.
}
