% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotplot.R
\name{highlight_query}
\alias{highlight_query}
\alias{highlight_target}
\title{Highlight segments of a query or target genome in a dot plot}
\usage{
highlight_query(bed, fill = "yellow", colour = "black", alpha = 0.6)

highlight_target(bed, fill = "yellow", colour = "black", alpha = 0.6)
}
\arguments{
\item{bed}{\code{data.frame} or \code{tbl_df} containing a bed file, as returned by
\code{\link{read_bed}}. Should contain three columns named 'chrom', 'start' 
 and 'end'}

\item{fill}{character  Fill colour for highlight segment}

\item{colour}{character  Outline colour for highlight segment}

\item{alpha}{character  Opacity ([0-1]) for highlight segment}
}
\description{
This plot is intended to be used in conjunction with \code{link{dotplot}}.
Adding \code{higlight_query} or \code{highlight_target} to a dotplot function call
(see examples below) will add a rectangular 'highlight' corresponding to a
particular genomic interval in the corresponding genome.
}
\examples{
ali <- read_paf( system.file("extdata", "fungi.paf", package="pafr") )
cen <- read_bed(system.file("extdata", "Q_centro.bed", package="pafr"))
dotplot(ali) + highlight_query(cen)
interval <- data.frame(chrom="T_chr3", start=2000000, end=3000000)
dotplot(ali, label_seqs=TRUE) + 
   highlight_target(interval)
}
