% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesForVariant.R
\name{genesForVariant}
\alias{genesForVariant}
\title{Retrieves variant-surrounding genes with calculated statistics for causal gene prioritization.}
\usage{
genesForVariant(variant_id)
}
\arguments{
\item{variant_id}{A character string specifying the ID of the variant for which to fetch gene information.}
}
\value{
A list with the following components:
\itemize{
  \item \code{v2g}: A data frame with all variant-to-gene information with the following data structure:
    - \code{gene.symbol}: character
    - \code{variant}: character
    - \code{overallScore}: numeric
    - \code{gene.id}: character
  \item \code{tssd}: A data frame with all details on colocalization scores effect of variant in expression of the genes across tissues with the following data structure:
    - \code{gene.symbol}: character
    - \code{variant}: character
    - \code{typeId}: character
    - \code{sourceId}: character
    - \code{aggregatedScore}: numeric
    - \code{tissues_distance}: integer
    - \code{tissues_score}: numeric
    - \code{tissues_quantile}: numeric
    - \code{tissues_id}: character
    - \code{tissues_name}: character
  \item \code{qtls}: List of QTL associations between genes and variants across analyzed tissues with the following data structure:
    - \code{gene.symbol}: character
    - \code{variant}: character
    - \code{typeId}: character
    - \code{aggregatedScore}: numeric
    - \code{tissues_quantile}: numeric
    - \code{tissues_beta}: numeric
    - \code{tissues_pval}: numeric
    - \code{tissues_id}: character
    - \code{tissues_name}: character
  \item \code{chromatin}: A data frame including all information on chromatin interactions effect involving genes and variants with the following data structure:
    - \code{gene.symbol}: character
    - \code{variant}: character
    - \code{typeId}: character
    - \code{sourceId}: character
    - \code{aggregatedScore}: numeric
    - \code{tissues_quantile}: numeric
    - \code{tissues_score}: numeric
    - \code{tissues_id}: character
    - \code{tissues_name}: character
  \item \code{functionalpred}: A data frame including predicted functional effects of variants on genes across tissues with the following data structure:
    - \code{gene.symbol}: character
    - \code{variant}: character
    - \code{typeId}: character
    - \code{sourceId}: character
    - \code{aggregatedScore}: numeric
    - \code{tissues_maxEffectLabel}: character
    - \code{tissues_maxEffectScore}: numeric
    - \code{tissues_id}: character
    - \code{tissues_name}: character
}
}
\description{
This function retrieves all calculated prioritizing scores for surrounding genes of a specific variant based on the Open Target Genetics locus-to-gene (L2G) ML scoring pipeline.
It provides detailed insights into the relationship between genetic variants and genes, allowing users to explore the impact of variants on gene expression, colocalization scores, chromatin interactions, and predicted functional effects.
The function returns the information in a structured format, making it easier to analyze and interpret the results.
}
\examples{
\dontrun{
  result <- genesForVariant(variant_id = "1_154453788_C_T")
  result <- genesForVariant(variant_id = "rs4129267")
  print(result)
}
}
