% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinvarQuery.R
\name{clinvarQuery}
\alias{clinvarQuery}
\title{Retrieve ClinVar data for a specified gene and disease.}
\usage{
clinvarQuery(ensemblId, efoId, size = 10, cursor = NULL)
}
\arguments{
\item{ensemblId}{Character: ENSEMBL ID of the target gene (e.g., ENSG00000130164).}

\item{efoId}{Character: EFO ID of the disease (e.g., EFO_0004911).}

\item{size}{Integer: Number of records to retrieve (default: 10).}

\item{cursor}{Character: Cursor for pagination (default: NULL).}
}
\value{
Returns a data frame containing ClinVar data for the specified gene and disease.
}
\description{
This function queries the Open Targets Genetics GraphQL API to retrieve ClinVar data
for a specified gene and disease, including evidence from the NCBI datasource.
}
\examples{
\dontrun{
result <- clinvarQuery(ensemblId = "ENSG00000130164",
 efoId = "EFO_0004911", size = 10)
result <- clinvarQuery(ensemblId = "ENSG00000130164",
 efoId = "EFO_0004911", size = 10, cursor = NULL)
}
}
