% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord-plot.r
\name{plot.tbl_ord}
\alias{plot.tbl_ord}
\title{Plot and biplot methods for 'tbl_ord' objects}
\usage{
\method{plot}{tbl_ord}(x, main = deparse(substitute(x)), ...)
}
\arguments{
\item{x}{A 'tbl_ord' object.}

\item{main}{A main title for the plot, passed to other methods (included to
enable parsing of object name).}

\item{...}{Additional arguments passed to other methods.}
}
\value{
Nothing, but a plot is produced on the current graphics device.
}
\description{
Adapt \strong{stats} 'prcomp' and 'princomp' methods for \code{plot()},
\code{screeplot()}, and \code{biplot()} generics to 'tbl_ord' objects.
}
\details{
These methods defer to any \code{plot()} and \code{biplot()} methods for the original,
underlying model classes of 'tbl_ord' objects. If none are found: Following
the examples of \code{\link[stats:prcomp]{stats::plot.prcomp()}} and \code{\link[stats:princomp]{stats::plot.princomp()}},
\code{plot.tbl_ord()} calls on \code{\link[stats:screeplot]{stats::screeplot()}} to produce a scree plot of the
decomposition of variance in the singular value decomposition. Similarly
following \code{\link[stats:biplot.princomp]{stats::biplot.prcomp()}} and \code{\link[stats:biplot.princomp]{stats::biplot.princomp()}},
\code{biplot.tbl_ord()} produces a biplot of both rows and columns, using text
labels when available and markers otherwise, with rows and columns
distinguished by color and no additional annotation (e.g. vectors). The
biplot confers inertia according to \code{\link[=get_conference]{get_conference()}} unless the proportions
do not sum to 1, in which case it produces a symmetric biplot (inertia
conferred equally to rows and columns).
}
\examples{
# note: behavior depends on installed packages with class-specific methods

# class 'prcomp'
iris_pca <- prcomp(iris[, -5L], scale = TRUE)
iris_pca_ord <- as_tbl_ord(iris_pca)
plot(iris_pca)
plot(iris_pca_ord)
screeplot(iris_pca)
screeplot(iris_pca_ord)
biplot(iris_pca)
biplot(iris_pca_ord)

# class 'correspondence'
haireye_ca <- MASS::corresp(rowSums(HairEyeColor, dims = 2L), nf = 2L)
haireye_ca_ord <- as_tbl_ord(haireye_ca)
plot(haireye_ca)
plot(haireye_ca_ord)
# no `screeplot()` method for class 'correspondence'
screeplot(haireye_ca_ord)
biplot(haireye_ca)
biplot(haireye_ca_ord)
}
