% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_power_t2error}
\alias{calculate_power_t2error}
\title{Calculate Hypothesis Test Parameters}
\usage{
calculate_power_t2error(
  df,
  alpha = 0.05,
  power_confidence_int = 95,
  n = NA_real_
)
}
\arguments{
\item{df}{Data frame where each column is a vector of p-values from a statistical test}

\item{alpha}{Numeric significance level; defaults to 0.05}

\item{power_confidence_int}{confidence interval}

\item{n}{Numeric value of sample size; repeated for convenience}
}
\value{
A data frame with columns for Type 1 error, Type 2 error, and power as well as rows for each test
}
\description{
This function calculates the power, Type II error, and Type I error of tests given p-values. Power, Type II error, and confidence intervals calculated using `stats::binom.test()` which implements the Newcombe method.
}
