% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-mixture.R
\name{plot_ridge_weights}
\alias{plot_ridge_weights}
\alias{plot_weights}
\alias{boxplot_weights}
\alias{plot_dyn_avg_loss}
\alias{plot_cumul_res}
\alias{plot_avg_loss}
\alias{plot_contrib}
\title{Functions to render dynamic mixture graphs using rAmCharts}
\usage{
plot_ridge_weights(data, colors = NULL, max_experts = 50, round = 3)

plot_weights(data, colors = NULL, max_experts = 50, round = 3)

boxplot_weights(data, colors = NULL, max_experts = 50)

plot_dyn_avg_loss(data, colors = NULL, max_experts = 50, round = 3)

plot_cumul_res(data, colors = NULL, max_experts = 50, round = 3)

plot_avg_loss(data, colors = NULL, max_experts = 50, round = 3)

plot_contrib(data, colors = NULL, alpha = 0.1, max_experts = 50, round = 3)
}
\arguments{
\item{data}{\code{mixture object}. Displays graphs.}

\item{colors}{\code{character}. Colors of the lines and bullets.}

\item{max_experts}{\code{integer}. Maximum number of experts to be displayed (only the more influencial).}

\item{round}{\code{integer}. Precision of the displayed values.}

\item{alpha}{\code{numeric}. Smoothing parameter for contribution plot (parameter 'f' of function \code{\link[stats]{lowess}}).}
}
\value{
a \code{rAmCharts} plot
}
\description{
Functions to render dynamic mixture graphs using rAmCharts
}
