% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.R
\name{runs}
\alias{runs}
\title{runs Class}
\description{
runs Class

runs Class
}
\section{Super class}{
\code{\link[openaistream:openai]{openaistream::openai}} -> \code{runs}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-runs-create}{\code{runs$create()}}
\item \href{#method-runs-retrieve}{\code{runs$retrieve()}}
\item \href{#method-runs-modify}{\code{runs$modify()}}
\item \href{#method-runs-list}{\code{runs$list()}}
\item \href{#method-runs-submit_tool_outputs}{\code{runs$submit_tool_outputs()}}
\item \href{#method-runs-cancel}{\code{runs$cancel()}}
\item \href{#method-runs-create_tread}{\code{runs$create_tread()}}
\item \href{#method-runs-steps_retrieve}{\code{runs$steps_retrieve()}}
\item \href{#method-runs-steps_list}{\code{runs$steps_list()}}
\item \href{#method-runs-clone}{\code{runs$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="openaistream" data-topic="openai" data-id="initialize"><a href='../../openaistream/html/openai.html#method-openai-initialize'><code>openaistream::openai$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-create"></a>}}
\if{latex}{\out{\hypertarget{method-runs-create}{}}}
\subsection{Method \code{create()}}{
Create a run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$create(thread_id, assistant_id, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thread_id}}{character Required. The ID of the thread to run.}

\item{\code{assistant_id}}{character Required. The ID of the assistant to use to execute this run.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:model,instructions,tools,metadata}

\item{\code{verbosity}}{numeric Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A run object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-runs-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieves a run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$retrieve(thread_id, run_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thread_id}}{character Required The ID of the thread the run belongs to.}

\item{\code{run_id}}{character Required The ID of the run to retrieve.}

\item{\code{verbosity}}{numeric Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The run object matching the specified ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-modify"></a>}}
\if{latex}{\out{\hypertarget{method-runs-modify}{}}}
\subsection{Method \code{modify()}}{
Modifies a run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$modify(thread_id, run_id, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thread_id}}{character Required The ID of the thread the run belongs to.}

\item{\code{run_id}}{character Required The ID of the run to retrieve.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}

\item{\code{verbosity}}{numeric Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The modified run object matching the specified ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-list"></a>}}
\if{latex}{\out{\hypertarget{method-runs-list}{}}}
\subsection{Method \code{list()}}{
Returns a list of runs for a given thread.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$list(thread_id, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thread_id}}{character Required The ID of the thread the run belongs to.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}

\item{\code{verbosity}}{numeric Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of run objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-submit_tool_outputs"></a>}}
\if{latex}{\out{\hypertarget{method-runs-submit_tool_outputs}{}}}
\subsection{Method \code{submit_tool_outputs()}}{
When a run has the status: "requires_action" and required_action.type is submit_tool_outputs,
             this endpoint can be used to submit the outputs from the tool calls once they're all completed.
             All outputs must be submitted in a single request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$submit_tool_outputs(thread_id, run_id, tool_outputs, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thread_id}}{character Required The ID of the thread the run belongs to.}

\item{\code{run_id}}{character Required The ID of the run to retrieve.}

\item{\code{tool_outputs}}{character Required. A list of tools for which the outputs are being submitted.}

\item{\code{verbosity}}{numeric Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The modified run object matching the specified ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-cancel"></a>}}
\if{latex}{\out{\hypertarget{method-runs-cancel}{}}}
\subsection{Method \code{cancel()}}{
Cancels a run that is in_progress.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$cancel(thread_id, run_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thread_id}}{character Required The ID of the thread the run belongs to.}

\item{\code{run_id}}{character Required The ID of the run to retrieve.}

\item{\code{verbosity}}{numeric Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The modified run object matching the specified ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-create_tread"></a>}}
\if{latex}{\out{\hypertarget{method-runs-create_tread}{}}}
\subsection{Method \code{create_tread()}}{
Create a thread and run it in one request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$create_tread(assistant_id, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{assistant_id}}{character Required The ID of the assistant to use to execute this run.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}

\item{\code{verbosity}}{numeric Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A run object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-steps_retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-runs-steps_retrieve}{}}}
\subsection{Method \code{steps_retrieve()}}{
Retrieves a run step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$steps_retrieve(thread_id, run_id, step_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thread_id}}{character Required. The ID of the thread to which the run and run step belongs.}

\item{\code{run_id}}{character Required. The ID of the run the step belongs to.}

\item{\code{step_id}}{character Required. The ID of the step to retrieve.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The run step object matching the specified ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-steps_list"></a>}}
\if{latex}{\out{\hypertarget{method-runs-steps_list}{}}}
\subsection{Method \code{steps_list()}}{
Returns a list of run steps belonging to a run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$steps_list(thread_id, run_id, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thread_id}}{character Required The ID of the thread the run belongs to.}

\item{\code{run_id}}{character Required The ID of the run the step belongs to.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}

\item{\code{verbosity}}{numeric Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of run step objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs-clone"></a>}}
\if{latex}{\out{\hypertarget{method-runs-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{runs$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
