% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{files}
\alias{files}
\title{Files Class}
\description{
Files Class

Files Class
}
\section{Super class}{
\code{\link[openaistream:openai]{openaistream::openai}} -> \code{files}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-files-upload}{\code{files$upload()}}
\item \href{#method-files-list}{\code{files$list()}}
\item \href{#method-files-delete}{\code{files$delete()}}
\item \href{#method-files-retrieve}{\code{files$retrieve()}}
\item \href{#method-files-retrieve_content}{\code{files$retrieve_content()}}
\item \href{#method-files-clone}{\code{files$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="openaistream" data-topic="openai" data-id="initialize"><a href='../../openaistream/html/openai.html#method-openai-initialize'><code>openaistream::openai$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-files-upload"></a>}}
\if{latex}{\out{\hypertarget{method-files-upload}{}}}
\subsection{Method \code{upload()}}{
Upload a file that can be used across various endpoints. The size of all the
             files uploaded by one organization can be up to 100 GB.The size of individual
             files can be a maximum of 512 MB or 2 million tokens for Assistants.
             See the Assistants Tools guide to learn more about the types of files supported.
             The Fine-tuning API only supports .jsonl files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{files$upload(path = NULL, verbosity = 0, purpose = "fine-tune")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{character Required. Path to the file that needs to be uploaded.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}

\item{\code{purpose}}{The intended purpose of the uploaded file.
Use "fine-tune" for Fine-tuning and "assistants" for Assistants and Messages.
This allows us to validate the format of the uploaded file is correct for fine-tuning.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The uploaded File object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-files-list"></a>}}
\if{latex}{\out{\hypertarget{method-files-list}{}}}
\subsection{Method \code{list()}}{
Returns a list of files that belong to the user's organization.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{files$list(..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:purpose}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of File objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-files-delete"></a>}}
\if{latex}{\out{\hypertarget{method-files-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{files$delete(file_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_id}}{character Required. The ID of the file to use for this request.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Deletion status.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-files-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-files-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Returns information about a specific file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{files$retrieve(file_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_id}}{character Required. The ID of the file to retrieve details for.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The File object matching the specified ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-files-retrieve_content"></a>}}
\if{latex}{\out{\hypertarget{method-files-retrieve_content}{}}}
\subsection{Method \code{retrieve_content()}}{
Returns information about a specific file content.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{files$retrieve_content(file_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_id}}{character Required. The ID of the file to retrieve details for.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The File object matching the specified ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-files-clone"></a>}}
\if{latex}{\out{\hypertarget{method-files-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{files$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
