% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_append_context.R
\name{body_append_start_context}
\alias{body_append_start_context}
\alias{write_elements_to_context}
\alias{body_append_stop_context}
\title{Fast Append context to a Word document}
\usage{
body_append_start_context(x, additional_ns = character())

write_elements_to_context(context, ...)

body_append_stop_context(context)
}
\arguments{
\item{x}{an rdocx object}

\item{additional_ns}{a named character vector of additional XML namespaces
to be added to the root node of the document. The names of the vector
are the namespace prefixes and the values are the namespace URIs.

This argument is useful when the elements to be added to the document require
additional namespaces that are not already present in the document and not
part of the xml generated by \code{to_wml()}. Simple users are not expected
to use this argument. It is mainly intended for developers of officer extensions.}

\item{context}{the context object created by \code{body_append_start_context()}.}

\item{...}{elements to be written to the context. These can be
paragraphs, tables, images, etc. The elements should have an associated
\code{to_wml()} method that converts them to WML format.}
}
\value{
\code{body_append_start_context()} returns a list representing the context
that contains:
\itemize{
\item \code{doc}: the original document object
\item \code{file_con}: the file connection to the context
\item \code{file_path}: the path to the context file
\item \code{final_str}: the final XML string to be appended to the document
later when calling \code{body_append_stop_context()}.
}

This object should not be modified by the user but instead
passed to \code{write_elements_to_context()} and \code{body_append_stop_context()}.

\code{write_elements_to_context()} returns the context object.

\code{body_append_stop_context()} returns the \code{rdocx} object with the
cursor position set to the end of the document.
}
\description{
This function is used to append content to a Word document
in a fast way.

It does not use the XML tree of the document
neither the cursor that is responsible for increasing the
performance of Word document generation when looping
over a large number of elements.

This function must be used with the \code{write_elements_to_context()}
and \code{body_append_stop_context()} functions:
\enumerate{
\item \code{body_append_start_context()} creates a context and returns
a list with the context and the file connection.
\item \code{write_elements_to_context()} writes the elements to the context
file connection.
\item \code{body_append_stop_context()} closes the file connection and
replaces the XML in the document with the new XML.
}
}
\examples{
library(officer)

doc <- read_docx()
doc <- body_add_par(doc, value = "blah blah blah", style = "Normal")

z <- body_append_start_context(doc)

for (i in seq_len(50)) {
  write_elements_to_context(
    context = z,
    fpar(
      "Hello World, ", i,
      fp_p = fp_par(word_style = "heading 1")),
    fpar(run_pagebreak())
  )
}
doc <- body_append_stop_context(z)


print(doc, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_caption}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_plot}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()},
\code{\link{body_import_docx}()}
}
\concept{functions for adding content}
