% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_replace.R
\name{docx_show_chunk}
\alias{docx_show_chunk}
\title{Show underlying text tag structure}
\usage{
docx_show_chunk(x)
}
\arguments{
\item{x}{a docx device}
}
\description{
Show the structure of text tags at the current cursor. This is
most useful when trying to troubleshoot search-and-replace functionality
using \code{\link[=body_replace_all_text]{body_replace_all_text()}}.
}
\examples{
doc <- read_docx()
doc <- body_add_par(doc, "Placeholder one")
doc <- body_add_par(doc, "Placeholder two")

# Show text chunk at cursor
docx_show_chunk(doc)  # Output is 'Placeholder two'
}
\seealso{
\code{\link[=body_replace_all_text]{body_replace_all_text()}}
}
