% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocsApiSharingManager.R
\docType{class}
\name{ocsApiSharingManager}
\alias{ocsApiSharingManager}
\title{ocsApiSharingManager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ocsManager for the Sharing API
}
\description{
ocsApiSharingManager
}
\section{General Methods (inherited from 'ocsManager')}{

\describe{
 \item{\code{new(url, user, pwd, logger, keyring_backend)}}{
   This method is used to instantiate an ocsApiSharingManager. The user/pwd are
   mandatory in order to connect to 'ocs'. 
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs).
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the user password with \pkg{keyring} (Default value is 'env').
 }
 \item{\code{connect()}}{
   A method to connect to 'ocs' and set version/capabilities
 }
 \item{\code{getVersion()}}{
   Get the 'ocs' server version
 }
 \item{\code{getCapabilities()}}{
   Get the 'ocs' server capabilities
 }
}
}

\section{'OCS' Share API methods}{

\describe{
 \item{\code{getShares(path, reshares, shared_with_me, state, subfiles, pretty)}}{
   Get list of shares as \code{list}. To return as \code{data.frame}, set 
   \code{pretty = TRUE}. The method accepts additional parameters. 
 }
 \item{\code{createShare(path, name, shareType, shareWith, publicUpload, password, 
 permissions = NULL, expireDate = NULL)}}{
   Creates a share for the path (file or folder), given a name. The \code{shareType} should be among
   values 'user','group','publiclink' or 'federated'.The \code{shareWith} is required for \code{shareType} 
   'user' and 'group' and corresponds to the username or groupname. The \code{permissions} can be set among
   values 'read', 'update', 'create', 'delete', 'read-write', 'share', 'all'. By default the permissions will 
   be the default permissions set by the ocs server (by default 'all').
 }
 \item{\code{shareWithUser(path, name, username, permissions, pretty)}}{
  Shares a resource (file or folder) with a user given its username handled with argument \code{username}. 
  The \code{permissions} can be set among values 'read', 'update', 'create', 'delete', 'read-write', 'share', 
  'all'. By default the permissions will be the default permissions set by the ocs server (by default 'all').
  Returns the share properties as \code{list} (or as\code{data.frame} if \code{pretty} is set to TRUE).
 }
 \item{\code{shareWithGroup(path, name, group, permissions, pretty)}}{
  Shares a resource (file or folder) with a group given its name handled with argument \code{group}. 
  The \code{permissions} can be set among values 'read', 'update', 'create', 'delete', 'read-write', 'share', 
  'all'. By default the permissions will be the default permissions set by the ocs server (by default 'all').
  Returns the share properties as \code{list} (or as\code{data.frame} if \code{pretty} is set to TRUE).
 }
 \item{\code{shareAsPublicLink(path, name, publicUpload, password, permissions, expireDate)}}{
  Shares a resource (file or folder) as public link. The function returns the public link generated by ocs.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{manager}
\keyword{ocs}
\keyword{sharing}
