% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pso.R
\name{particle_swarm_optimization}
\alias{particle_swarm_optimization}
\title{Implementation of Particle Swarm Optimization (PSO) metaheuristic algorithm.}
\usage{
particle_swarm_optimization(
  d = 10,
  np = 10,
  w = 0.7,
  c1 = 1.5,
  c2 = 1.5,
  nfes = 1000,
  features,
  data,
  is_time_series = FALSE
)
}
\arguments{
\item{d}{Dimension of the problem (default: 10).}

\item{np}{Population size (default: 10).}

\item{w}{Inertia weight (default: 0.7).}

\item{c1}{Cognitive coefficient (default: 1.5).}

\item{c2}{Social coefficient (default: 1.5).}

\item{nfes}{The maximum number of function evaluations (default: 1000).}

\item{features}{A list containing information about features, including type and bounds.}

\item{data}{A data frame representing instances in the dataset.}

\item{is_time_series}{A boolean indicating whether the dataset is time series.}
}
\value{
A list containing the best solution, its fitness value, and the number of function evaluations and list of identified association rules.
}
\description{
This function uses PSO, a stochastic population-based optimization algorithm,
to find the optimal numerical association rule.
}
\references{
Kennedy, J., & Eberhart, R. (1995). "Particle swarm optimization."
Proceedings of ICNN'95 - International Conference on Neural Networks, 4, 1942–1948.
IEEE. \doi{10.1109/ICNN.1995.488968}
}
