% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checknii.R
\docType{methods}
\name{checknii-methods}
\alias{checknii-methods}
\alias{checknii}
\alias{checknii,nifti-method}
\alias{checknii,factor-method}
\alias{checknii,character-method}
\alias{checknii,list-method}
\alias{checknii,ANY-method}
\alias{ensure_nii}
\title{Force object to filename with .nii extension}
\usage{
checknii(file, ...)

\S4method{checknii}{nifti}(file, ...)

\S4method{checknii}{factor}(file, ...)

\S4method{checknii}{character}(file, ...)

\S4method{checknii}{list}(file, ...)

\S4method{checknii}{ANY}(file, ...)

ensure_nii(file, ...)
}
\arguments{
\item{file}{character or \code{nifti} object}

\item{...}{options passed to \code{\link{checkimg}}}
}
\value{
character filename of image or temporary nii, 
with .nii extension
}
\description{
Ensures the output to be a character filename (or vector) from an input
image or \code{nifti}, but not gzipped and has \code{.nii} extension
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)
rnifti = RNifti::asNifti(nim)
timg = tempimg(nim)
limg = list(factor(timg), factor(timg))
func = checknii
func(nim)
func(rnifti)
func(timg)
func(limg)
}
\author{
John Muschelli \email{muschellij2@gmail.com}
}
