% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-form.R
\name{ns_get_form_reports}
\alias{ns_get_form_reports}
\title{Download files associated with a form}
\usage{
ns_get_form_reports(
  form_id,
  type = c("csv", "excel", "spss"),
  path = report_path(form_id, type)
)
}
\arguments{
\item{form_id}{integer. Number of the form to retrieve}

\item{type}{Character. Either "csv", "excel" or
"spss".}

\item{path}{Character. Full path to where the
downloaded file should be saved. Defaults to
current directory with correct extension.}
}
\value{
httr2-response
}
\description{
Each Nettskjema form has several
auxiliary forms that can be retrieved.
}
\examples{
\dontrun{
ns_get_form_reports(10009, type="csv")
ns_get_form_reports(10009, type="excel")
ns_get_form_reports(10009, type="spss")
ns_get_form_reports(
  10009,
  type="spss",
  path = "~/Desktop/10009/form.sav"
)
}
}
