% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{c_EdgeListFromSegList}
\alias{c_EdgeListFromSegList}
\title{Turn a segment list into an edgelist suitable for constructing an ngraph}
\usage{
c_EdgeListFromSegList(L)
}
\arguments{
\item{L}{a list containing integer vectors from \code{as.seglist}}
}
\value{
An integer matrix of N rows and 2 columns
}
\description{
Turn a segment list into an edgelist suitable for constructing an ngraph
}
\details{
It is up to the caller to generate the \code{seglist}.
Note that isolated points will be dropped since they have no edges.
}
\examples{

\dontrun{
library(nat)
# make a neuron with multiple subtrees
n=prune_vertices(Cell07PNs[[1]], 48L)
# Must use flatten=T if including all subtrees
sl=as.seglist(n, all = TRUE, flatten = TRUE)
c_EdgeListFromSegList(sl)
}
}
