% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disambi.R
\name{disambiguate_lga}
\alias{disambiguate_lga}
\title{Disambiguate Synonymous States and LGAs}
\usage{
disambiguate_lga(lga, state = NULL, ...)
}
\arguments{
\item{lga}{An object of class \code{lgas} of length \code{1L}.}

\item{state}{The name of the State to which the LGA is to belong to.}

\item{...}{Arguments to be passed to \code{\link[utils]{menu}}.}
}
\value{
The object of class \code{lgas} with the (possibly) modified 
\code{State} attribute.
}
\description{
Some LGAs in Nigeria bear the name of the States to which they belong to.
This function will apply an attribute to such an LGA to distinguish it from
its State.
}
\details{
For \code{state}, if it is not provided by the user, an interactive
prompt will be presented to the user to select the appropriate state - but 
only in interactive sessions; if run as a batch command, this function
will signal an error.
}
\examples{
obi.lga <- lgas("Obi")    # Warning
try(map_ng(obi.lga))      # Error

obi.benue <- disambiguate_lga(obi.lga, "Benue")

if (interactive())
  map_ng(obi.benue)

}
