% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{mc_plot_image}
\alias{mc_plot_image}
\title{Plot data - image}
\usage{
mc_plot_image(
  data,
  filename,
  title = "",
  localities = NULL,
  sensors = NULL,
  height = 1900,
  left_margin = 12,
  use_utc = TRUE
)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{filename}{output file name (file path)}

\item{title}{of plot; default is empty}

\item{localities}{names of localities; if NULL then all (default NULL)}

\item{sensors}{names of sensors; if NULL then all (default NULL) see \code{names(mc_data_sensors)}}

\item{height}{of image; default = 1900}

\item{left_margin}{width of space for sensor_labels; default = 12}

\item{use_utc}{if FALSE, then the time shift from \code{tz_offset} metadata is used to correct
(shift) the output time-series (default TRUE)

In the Agg-format myClim object \code{use_utc = FALSE} is allowed only for steps shorter than one day. In myClim
the day nd longer time steps are defined by the midnight, but this represent whole day, week, month, year...
shifting daily, weekly, monthly... data (shift midnight) does not make sense in our opinion.
But when user need more flexibility, then myClim Raw-format
can be used, In Raw-format \code{use_utc} is not limited, user can shift an data without the restrictions.
See \link{myClim-package}}
}
\value{
PNG file created as specified in output file name
}
\description{
Function plots single sensor form myClim data into PNG file with image() R base function.
This was designed for fast, and easy data visualization especially focusing on missing
values visualization and general data picture.
}
\details{
Be careful with bigger data. Can take some time.
}
\examples{
tmp_dir <- tempdir()
tmp_file <- tempfile(tmpdir = tmp_dir)
mc_plot_image(mc_data_example_clean, tmp_file, "T1 sensor", sensors="TMS_T1")
file.remove(tmp_file)
}
