% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-coord.R
\name{pivot_coord_rotate}
\alias{pivot_coord_rotate}
\title{Estimate pivot balance coordinates by rotating sequential binary partition.}
\usage{
pivot_coord_rotate(object, summary = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{summary}{Should summary statistics be returned instead of the raw values? Default is \code{TRUE}.}

\item{...}{currently ignored.}
}
\value{
A list of \code{\link{brmcoda}} for each pivot balance coordinate.
}
\description{
Estimate pivot balance coordinates by rotating sequential binary partition.
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  cilr <- complr(data = mcompd, sbp = sbp,
                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID",
                 total = 1440)
  
  m <- brmcoda(complr = cilr,
                formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
                                   wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
                chain = 1, iter = 500,
                backend = "cmdstanr")
  
  m_pivot_coord_rotate <- pivot_coord_rotate(m)
  summary(m_pivot_coord_rotate)
  
  m_pivot_coord_raw <-  pivot_coord_rotate(m, summary = FALSE)
  posterior::summarise_draws(posterior::as_draws_array(m_pivot_coord_raw$output))
  }}
}
