% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgsim_q.R
\name{mrgsim_q}
\alias{mrgsim_q}
\title{Simulate from a model object with quicker turnaround}
\usage{
mrgsim_q(
  x,
  data,
  recsort = 1,
  stime = numeric(0),
  output = "mrgsims",
  skip_init_calc = FALSE,
  simcall = 0,
  etasrc = "omega"
)
}
\arguments{
\item{x}{a model object.}

\item{data}{a simulation data set.}

\item{recsort}{record sorting flag.}

\item{stime}{a numeric vector of observation times; these observation
times will only be added to the output if there are no observation
records in \code{data}.}

\item{output}{output data type; if \verb{"mrgsims", then the default output object is returned; if }"df"` then a data frame is returned.}

\item{skip_init_calc}{don't use \verb{$MAIN} to calculate initial conditions.}

\item{simcall}{not used; only the default value of 0 is allowed.}

\item{etasrc}{source for ETA() values in the model; values can include:
"omega", \code{"data"}, \code{"data.all"}, \code{"idata"}, or \code{"idata.all"}; see
'Details' in \code{\link[=mrgsim]{mrgsim()}}.}
}
\value{
By default, an object of class \code{mrgsims}. Use \code{output = "df"} to return
a data frame.
}
\description{
Use the function when you would usually use \code{\link[=mrgsim_d]{mrgsim_d()}},
but you need a quicker turnaround time.  The timing differences
might be difficult to detect for a single simulation run
but could become appreciable with repeated simulation.  See
\strong{Details} for important differences in how \code{mrgsim_q()}
is invoked compared to \code{\link[=mrgsim]{mrgsim()}} and \code{\link[=mrgsim_d]{mrgsim_d()}}.
This function should always be used for benchmarking simulation time with
mrgsolve.
}
\details{
\code{mrgsim_q()} mainly cuts some of the overhead from the simulation. So, the
primary efficiency gain from using \code{mrgsim_q()} comes when the simulation
executes very quickly. It is unlikely you will see a big performance
difference between \code{mrgsim_q()} and \code{\link[=mrgsim]{mrgsim()}} when the model is difficult to
solve or if there is a large input data set.

This function does not support the piped simulation workflow.  All
arguments must be passed into the function except for \code{x}.

A data set is required for this simulation workflow.  The
data set can have only dosing records or doses with observations.
When the data set only includes doses, a single numeric vector of
observation times should be passed in.

This simulation workflow does not support \code{Req} (request)
functionality.  All compartments and captured variables will
always be returned in the simulation output.

This simulation workflow does not support carry-out functionality.

This simulation workflow does not accept arguments to be passed
to \code{\link[=update]{update()}}. This must be done by a separate
call to \code{\link[=update]{update()}}.

This simulation workflow does not support use of event objects.  If
an event object is needed, it should be converted to a data set
prior to the simulation run (see \code{\link[=as_data_set]{as_data_set()}} or
\code{\link[=as.data.frame]{as.data.frame()}}).

This simulation workflow does not support idata sets or any
feature enabled by \code{idata} set use.  Individual level parameters
should be joined onto the data set prior to simulation.  Otherwise
\code{\link[=mrgsim_i]{mrgsim_i()}} or \code{\link[=mrgsim_ei]{mrgsim_ei()}} should be used.

By default, a mrgsims object is returned (as with \code{\link[=mrgsim]{mrgsim()}}).
Use the \code{output = "df"} argument to request a plain
data.frame of simulated data on return.
}
\examples{
mod <- mrgsolve::house()

data <- expand.ev(amt = c(100, 300, 1000))

out <- mrgsim_q(mod, data)

out

}
\seealso{
\code{\link[=mrgsim]{mrgsim()}}, \link{mrgsim_variants}, \code{\link[=qsim]{qsim()}}
}
