% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_raw_optflow_view}
\alias{get_raw_optflow_view}
\title{Creates time reference and displacement from raw csv optflow data}
\usage{
get_raw_optflow_view(
  recording,
  vid,
  direct,
  inst,
  folder_out = tempdir(),
  save_output = FALSE,
  filetype = "rda",
  verbose = FALSE
)
}
\arguments{
\item{recording}{\code{Recording} object.}

\item{vid}{camera.}

\item{direct}{direction.}

\item{inst}{instrument.}

\item{folder_out}{output folder relative to recording home  (default is 'tempdir()').}

\item{save_output}{save the output?}

\item{filetype}{type of file ('rda' as default), can be 'csv'.}

\item{verbose}{messages the specific data loaded (default is 'FALSE').}
}
\value{
an \code{OptFlowView} object.
}
\description{
Used to load OptFlow data.
}
\examples{
r <- get_recording("NIR_ABh_Puriya", fps = 25)
rov <- get_raw_optflow_view(r, "Central" ,"", "Sitar")
pov <- get_processed_view(rov)
fv1 <- apply_filter_sgolay(pov, c("Head"), n=19, p=4)
autoplot(fv1)
}
\seealso{
Other data functions: 
\code{\link{apply_filter_sgolay}()},
\code{\link{get_data_points}()},
\code{\link{get_duration_annotation_data}()},
\code{\link{get_feature_data}()},
\code{\link{get_filtered_views}()},
\code{\link{get_joined_view}()},
\code{\link{get_metre_data}()},
\code{\link{get_onsets_selected_data}()},
\code{\link{get_processed_views}()},
\code{\link{get_processed_view}()},
\code{\link{get_raw_views}()},
\code{\link{get_raw_view}()},
\code{\link{get_recording}()},
\code{\link{get_sample_recording}()}
}
\concept{data functions}
