% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{apply_segment_spliceview}
\alias{apply_segment_spliceview}
\title{Apply complex function to each segment in a SpliceView object}
\usage{
apply_segment_spliceview(sv, FUN, ...)
}
\arguments{
\item{sv}{\code{SplicedView} object.}

\item{FUN}{function to apply.}

\item{...}{passed to FUN.}
}
\value{
list of two elements: 'output' containing results of apply FUN to 'input'
}
\description{
Apply complex function to each segment in a SpliceView object
}
\examples{
r <- get_sample_recording()
d1 <- get_duration_annotation_data(r)
# only one relevant section for sample data
splicing_smile_df <- splice_time(d1, tier ='INTERACTION',
  comments = 'Mutual look and smile')

fv_list <- get_filtered_views(r, data_points = "Nose", n = 41, p = 3)
jv <- get_joined_view(fv_list)
sv_duration_smile <- get_spliced_view(jv, splicing_df = splicing_smile_df)
wavelet_smile_list <- apply_segment_spliceview(sv_duration_smile, analyze_wavelet,
  column = "Nose_x_Central_Sitar")
names(wavelet_smile_list)
}
\seealso{
Other statistical and analysis functions: 
\code{\link{apply_column_spliceview}()},
\code{\link{ave_cross_power_over_splices}()},
\code{\link{ave_cross_power_spliceview}()},
\code{\link{ave_power_over_splices}()},
\code{\link{ave_power_spliceview}()},
\code{\link{calculate_ave_cross_power1}()},
\code{\link{calculate_ave_power1}()},
\code{\link{compare_ave_cross_power1}()},
\code{\link{compare_ave_power1}()},
\code{\link{compare_avg_cross_power2}()},
\code{\link{compare_avg_power2}()},
\code{\link{difference_onsets}()},
\code{\link{pull_segment_spliceview}()},
\code{\link{sample_gap_splice}()},
\code{\link{sample_offset_splice}()},
\code{\link{summary_onsets}()},
\code{\link{visualise_sample_splices}()}
}
\concept{statistical and analysis functions}
