% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsp_restructure.R
\name{lsp_restructure}
\alias{lsp_restructure}
\title{Changes structure of the lsp object}
\usage{
lsp_restructure(x)
}
\arguments{
\item{x}{\itemize{
\item an lsp object
}}
}
\value{
Object of class \code{lsp}.
It has several columns: (1) \code{id} - an id of each window.
For irregular windows, it is the values provided in the \code{window} argument,
(2) \code{na_prop} - share (0-1) of \code{NA} cells for each window,
(3) one or more columns representing values of the signature
}
\description{
Converts a list-column with signatures into many numeric columns
}
\examples{

library(stars)

landcover = read_stars(system.file("raster/landcover2015s.tif", package = "motif"))

landcover_cove = lsp_signature(landcover, type = "cove", threshold = 0.9, window = 100)
landcover_cover = lsp_restructure(landcover_cove)
landcover_cover

lsp_add_sf(landcover_cover)
}
