% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffmean.R
\name{diffmean}
\alias{diffmean}
\alias{diffprop}
\title{Difference in means and proportions}
\usage{
diffmean(x, ..., data = parent.frame(), only.2 = TRUE)

diffprop(x, ..., data = parent.frame(), only.2 = TRUE)
}
\arguments{
\item{x, data, ...}{as in \code{\link[=mean]{mean()}} or \code{\link[=prop]{prop()}}}

\item{only.2}{a logical indicating whether differences should only be computed
between two groups.}
}
\description{
Wrappers around \code{diff(mean(...))} and \code{diff(prop(...))} that
facilitate better naming of the result
}
\examples{
if (require(mosaicData)) {
diffprop( homeless ~ sex , data=HELPrct)
do(3) * diffprop( homeless ~ shuffle(sex) , data=HELPrct)
diffmean( age ~ substance, data=HELPrct, only.2=FALSE)
do(3) * diffmean(age ~ shuffle(substance), data=HELPrct, only.2=FALSE)
diffmean( age ~ sex, data=HELPrct)
do(3) * diffmean(age ~ shuffle(sex), data=HELPrct)
}
}
