% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nondominated.R
\name{is_nondominated}
\alias{is_nondominated}
\alias{filter_dominated}
\alias{pareto_rank}
\title{Identify, remove and rank dominated points according to Pareto optimality}
\usage{
is_nondominated(x, maximise = FALSE, keep_weakly = FALSE)

filter_dominated(x, maximise = FALSE, keep_weakly = FALSE)

pareto_rank(x, maximise = FALSE)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}

\item{keep_weakly}{\code{logical(1)}\cr If \code{FALSE}, return \code{FALSE} for any
duplicates of nondominated points.  Which of the duplicates is identified
as nondominated is unspecified due to the sorting not being stable in this
version.}
}
\value{
\code{\link[=is_nondominated]{is_nondominated()}} returns a logical vector of the same length
as the number of rows of \code{data}, where \code{TRUE} means that the
point is not dominated by any other point.

\code{filter_dominated} returns a matrix or data.frame with only mutually nondominated points.

\code{pareto_rank()} returns an integer vector of the same length as
the number of rows of \code{data}, where each value gives the rank of each
point.
}
\description{
Identify nondominated points with \code{is_nondominated()} and remove dominated
ones with \code{filter_dominated()}.

\code{pareto_rank()} ranks points according to Pareto-optimality,
which is also called nondominated sorting \citep{Deb02nsga2}.
}
\details{
Given \eqn{n} points of dimension \eqn{m}, the current implementation uses
the well-known \eqn{O(n \log n)} dimension-sweep algorithm
\citep{KunLucPre1975jacm} for \eqn{m \leq 3} and the naive \eqn{O(m n^2)}
algorithm for \eqn{m \geq 4}.

\code{pareto_rank()} is meant to be used like \code{rank()}, but it
assigns ranks according to Pareto dominance. Duplicated points are kept on
the same front. When \code{ncol(data) == 2}, the code uses the \eqn{O(n
  \log n)} algorithm by \citet{Jen03}.
}
\examples{
S = matrix(c(1,1,0,1,1,0,1,0), ncol = 2, byrow = TRUE)
is_nondominated(S)

is_nondominated(S, maximise = TRUE)

filter_dominated(S)

filter_dominated(S, keep_weakly = TRUE)

path_A1 <- file.path(system.file(package="moocore"),"extdata","ALG_1_dat.xz")
set <- read_datasets(path_A1)[,1:2]
is_nondom <- is_nondominated(set)
cat("There are ", sum(is_nondom), " nondominated points\n")

if (requireNamespace("graphics", quietly = TRUE)) {
   plot(set, col = "blue", type = "p", pch = 20)
   ndset <- filter_dominated(set)
   points(ndset[order(ndset[,1]),], col = "red", pch = 21)
}

ranks <- pareto_rank(set)
str(ranks)
if (requireNamespace("graphics", quietly = TRUE)) {
   colors <- colorRampPalette(c("red","yellow","springgreen","royalblue"))(max(ranks))
   plot(set, col = colors[ranks], type = "p", pch = 20)
}
}
\references{
\insertAllCited{}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\concept{dominance}
