% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_h0.R
\name{estimate_h0}
\alias{estimate_h0}
\alias{estimate_h0.modsem_da}
\alias{estimate_h0.modsem_pi}
\title{Estimate baseline model for \code{modsem} models}
\usage{
estimate_h0(object, warn_no_interaction = TRUE, ...)

\method{estimate_h0}{modsem_da}(object, warn_no_interaction = TRUE, ...)

\method{estimate_h0}{modsem_pi}(object, warn_no_interaction = TRUE, reduced = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{\link{modsem_da}} or \code{\link{modsem_pi}}.}

\item{warn_no_interaction}{Logical. If `TRUE`, a warning is issued if no interaction terms are found in the model.}

\item{...}{Additional arguments passed to the `modsem_da` function, overriding
the arguments in the original model.}

\item{reduced}{Should the baseline model be a reduced version of the model? 
If \code{TRUE}, the latent product term and its (product) indicators are kept in the model,
but the interaction coefficients are constrained to zero. If \code{FALSE}, the
interaction terms are removed completely from the model. Note that the models will no longer be 
nested, if the interaction terms are removed from the model completely.}
}
\description{
Estimates a baseline model (H0) from a given model (H1).
The baseline model is estimated by removing all interaction terms from the model.
}
\section{Methods (by class)}{
\itemize{
\item \code{estimate_h0(modsem_da)}: Estimate baseline model for \code{\link{modsem_da}} objects

\item \code{estimate_h0(modsem_pi)}: Estimate baseline model for \code{\link{modsem_pi}} objects

}}
\examples{
\dontrun{
m1 <- "
 # Outer Model
 X =~ x1 + x2 + x3
 Y =~ y1 + y2 + y3
 Z =~ z1 + z2 + z3

 # Inner model
 Y ~ X + Z + X:Z
"

# LMS approach
est_h1 <- modsem(m1, oneInt, "lms")
est_h0 <- estimate_h0(est_h1, calc.se=FALSE) # std.errors are not needed
compare_fit(est_h1 = est_h1, est_h0 = est_h0)

# Double centering approach
est_h1 <- modsem(m1, oneInt, method = "dblcent")
est_h0 <- estimate_h0(est_h1, oneInt)

compare_fit(est_h1 = est_h1, est_h0 = est_h0)

# Constrained approach
est_h1 <- modsem(m1, oneInt, method = "ca")
est_h0 <- estimate_h0(est_h1, oneInt)

compare_fit(est_h1 = est_h1, est_h0 = est_h0)
}
}
