% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSptCVCstf.R
\name{mlr_resamplings_sptcv_cstf}
\alias{mlr_resamplings_sptcv_cstf}
\alias{ResamplingSptCVCstf}
\title{(CAST) Spatiotemporal "Leave-location-and-time-out" resampling}
\description{
Splits data using Leave-Location-Out (LLO), Leave-Time-Out (LTO) and
Leave-Location-and-Time-Out (LLTO) partitioning.
See the upstream implementation at \code{CreateSpacetimeFolds()}
(package \CRANpkg{CAST}) and Meyer et al. (2018) for further information.
}
\details{
LLO predicts on unknown locations i.e. complete locations are left out in the
training sets.
The \code{"space"} role in \code{Task$col_roles} identifies spatial units.
If \code{stratify} is \code{TRUE}, the target distribution is similar in each fold.
This is useful for land cover classification when the observations
are polygons.
In this case, LLO with stratification should be used to hold back complete
polygons and have a similar target distribution in each fold.
LTO leaves out complete temporal units which are identified by the
\code{"time"} role in \code{Task$col_roles}.
LLTO leaves out spatial and temporal units.
See the examples.
}
\section{Parameters}{

\itemize{
\item \code{folds} (\code{integer(1)})\cr
Number of folds.
\item \code{stratify}\cr
If \code{TRUE}, stratify on the target column.
}
}

\examples{
\donttest{
library(mlr3)
task = tsk("cookfarm_mlr3")
task$set_col_roles("SOURCEID", roles = "space")
task$set_col_roles("Date", roles = "time")

# Instantiate Resampling
rcv = rsmp("sptcv_cstf", folds = 5)
rcv$instantiate(task)

### Individual sets:
# rcv$train_set(1)
# rcv$test_set(1)
# check that no obs are in both sets
intersect(rcv$train_set(1), rcv$test_set(1)) # good!

# Internal storage:
# rcv$instance # table
}
}
\references{
Meyer H, Reudenbach C, Hengl T, Katurji M, Nauss T (2018).
\dQuote{Improving performance of spatio-temporal machine learning models using forward feature selection and target-oriented validation.}
\emph{Environmental Modelling & Software}, \bold{101}, 1--9.
\doi{10.1016/j.envsoft.2017.12.001}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingSptCVCstf}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingSptCVCstf-new}{\code{ResamplingSptCVCstf$new()}}
\item \href{#method-ResamplingSptCVCstf-instantiate}{\code{ResamplingSptCVCstf$instantiate()}}
\item \href{#method-ResamplingSptCVCstf-clone}{\code{ResamplingSptCVCstf$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSptCVCstf-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSptCVCstf-new}{}}}
\subsection{Method \code{new()}}{
Create a "Spacetime Folds" resampling instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSptCVCstf$new(id = "sptcv_cstf")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSptCVCstf-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSptCVCstf-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSptCVCstf$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link[mlr3:Task]{mlr3::Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSptCVCstf-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSptCVCstf-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSptCVCstf$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
