% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify_if}
\alias{modify_if}
\alias{modify_at}
\title{Selectively Modify Elements of a Vector}
\usage{
modify_if(.x, .p, .f, ...)

modify_at(.x, .at, .f, ...)
}
\arguments{
\item{.x}{(\code{vector()}).}

\item{.p}{(\verb{function()})\cr
Predicate function.}

\item{.f}{(\verb{function()})\cr
Function to apply on \code{.x}.}

\item{...}{(\code{any})\cr
Additional arguments passed to \code{.f}.}

\item{.at}{((\code{integer()} | \code{character()}))\cr
Index vector to select elements from \code{.x}.}
}
\description{
Modifies elements of a vector selectively, similar to the functions in \CRANpkg{purrr}.

\code{modify_if()} applies a predicate function \code{.p} to all elements of \code{.x}
and applies \code{.f} to those elements of \code{.x} where \code{.p} evaluates to \code{TRUE}.

\code{modify_at()} applies \code{.f} to those elements of \code{.x} selected via \code{.at}.
}
\examples{
x = modify_if(iris, is.factor, as.character)
str(x)

x = modify_at(iris, 5, as.character)
x = modify_at(iris, "Sepal.Length", sqrt)
str(x)
}
