% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OutputTrafoStandardize.R
\name{OutputTrafoStandardize}
\alias{OutputTrafoStandardize}
\title{Output Transformation Standardization}
\description{
Output transformation that performs standardization to zero mean and unit variance.
}
\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)

  fun = function(xs) {
    list(y = xs$x ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceBatchSingleCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  xdt = generate_design_random(instance$search_space, n = 4)$data

  instance$eval_batch(xdt)

  learner = default_gp()

  output_trafo = ot("standardize", invert_posterior = TRUE)

  surrogate = srlrn(learner, output_trafo = output_trafo, archive = instance$archive)

  surrogate$update()

  surrogate$output_trafo$state

  surrogate$predict(data.table(x = c(-1, 0, 1)))

  surrogate$output_trafo$invert_posterior = FALSE

  surrogate$predict(data.table(x = c(-1, 0, 1)))
}
}
\seealso{
Other Output Transformation: 
\code{\link{OutputTrafo}},
\code{\link{OutputTrafoLog}},
\code{\link{mlr_output_trafos}}
}
\concept{Output Transformation}
\section{Super class}{
\code{\link[mlr3mbo:OutputTrafo]{mlr3mbo::OutputTrafo}} -> \code{OutputTrafoStandardize}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OutputTrafoStandardize-new}{\code{OutputTrafoStandardize$new()}}
\item \href{#method-OutputTrafoStandardize-update}{\code{OutputTrafoStandardize$update()}}
\item \href{#method-OutputTrafoStandardize-transform}{\code{OutputTrafoStandardize$transform()}}
\item \href{#method-OutputTrafoStandardize-inverse_transform_posterior}{\code{OutputTrafoStandardize$inverse_transform_posterior()}}
\item \href{#method-OutputTrafoStandardize-inverse_transform}{\code{OutputTrafoStandardize$inverse_transform()}}
\item \href{#method-OutputTrafoStandardize-clone}{\code{OutputTrafoStandardize$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="OutputTrafo" data-id="format"><a href='../../mlr3mbo/html/OutputTrafo.html#method-OutputTrafo-format'><code>mlr3mbo::OutputTrafo$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="OutputTrafo" data-id="print"><a href='../../mlr3mbo/html/OutputTrafo.html#method-OutputTrafo-print'><code>mlr3mbo::OutputTrafo$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoStandardize-new"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoStandardize-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoStandardize$new(invert_posterior = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{invert_posterior}}{(\code{logical(1)})\cr
Should the posterior predictive distribution be inverted when used within a \link{SurrogateLearner} or \link{SurrogateLearnerCollection}?
Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoStandardize-update"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoStandardize-update}{}}}
\subsection{Method \code{update()}}{
Learn the transformation based on observed data and update parameters in \verb{$state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoStandardize$update(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoStandardize-transform"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoStandardize-transform}{}}}
\subsection{Method \code{transform()}}{
Perform the transformation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoStandardize$transform(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the transformation applied to the columns \verb{$cols_y}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoStandardize-inverse_transform_posterior"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoStandardize-inverse_transform_posterior}{}}}
\subsection{Method \code{inverse_transform_posterior()}}{
Perform the inverse transformation on a posterior predictive distribution characterized by the first and second moment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoStandardize$inverse_transform_posterior(pred)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pred}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation characterizing a posterior predictive distribution with the columns \code{mean} and \code{se}.
Can also be a named list of \code{\link[data.table:data.table]{data.table::data.table()}} with posterior predictive distributions for multiple targets corresponding to (\code{cols_y}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the inverse transformation applied to the columns \code{mean} and \code{se}.
In the case of the input being a named list of \code{\link[data.table:data.table]{data.table::data.table()}}, the output will be a named list of \code{\link[data.table:data.table]{data.table::data.table()}} with the inverse transformation applied to the columns \code{mean} and \code{se}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoStandardize-inverse_transform"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoStandardize-inverse_transform}{}}}
\subsection{Method \code{inverse_transform()}}{
Perform the inverse transformation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoStandardize$inverse_transform(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the inverse transformation applied to the columns \verb{$cols_y}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoStandardize-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoStandardize-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoStandardize$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
